//
//  WDVolumeModel.h
//  SmartWare
//
//  Created by Clark Jackson on 1/19/11.
//  Copyright 2011 Western Digital Technologies, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class WDDeviceModel;

@interface WDVolumeModel : NSObject
{
    NSString* name; // like 'My Book'
    NSString* mountPoint; // like '/Volumes/My Book'
    NSString* bsdNodeName;
    NSString* bootDriveName; // you need a bootDriveName in addition to volume name because volume name can be '/' and what needs to show is 'Macintosh HD'
    WDDeviceModel* parentDevice; // I'm a volume on this device
    int smartWareType; // source or destination
    unsigned long long capacityBytes; // UInt64
}

@property (readwrite, retain) NSString* name, *bsdNodeName, *bootDriveName, *mountPoint;
@property (readwrite, assign) WDDeviceModel* parentDevice; // this results in retain cycles memory leaking if you make it (readwrite, retain)
@property (readwrite, assign) int smartWareType;
@property (readwrite, assign) unsigned long long capacityBytes;

- (BOOL) isOnVCDDevice;
- (NSString*) description;
- (NSString*) pidAsHexString;
- (NSString*) pidAsDecString;
- (NSString*) serialNumber;

@end
